/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.item;

import com.cobblemon.mod.common.block.PastureBlock;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.provismet.cobblemon.daycareplus.gui.EggStorageGUI;
import com.provismet.cobblemon.daycareplus.imixin.IMixinPastureBlockEntity;
import com.provismet.cobblemon.daycareplus.item.PolymerItem;
import com.provismet.cobblemon.daycareplus.item.component.IncubatorOwner;
import com.provismet.cobblemon.daycareplus.item.component.IncubatorType;
import com.provismet.cobblemon.daycareplus.registries.DPItemDataComponents;
import com.provismet.cobblemon.daycareplus.storage.EggStorage;
import com.provismet.cobblemon.daycareplus.storage.IncubatorCollection;
import com.provismet.cobblemon.daycareplus.util.Styles;
import com.provismet.cobblemon.daycareplus.util.tag.DPItemTags;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class IncubatorItem
extends PolymerItem {
    public static final Set<String> HATCH_ABILITIES = Set.of("flamebody", "steamengine", "magmaarmor");
    private final PolymerModelData hasEggData;

    public IncubatorItem(class_1792.class_1793 settings, class_1792 baseVanillaItem, PolymerModelData normalData, PolymerModelData hasEggData) {
        super(settings, baseVanillaItem, normalData);
        this.hasEggData = hasEggData;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_7337()) {
            user.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.daycareplus.incubator.creative").method_27692(class_124.field_1061), true);
            return class_1271.method_22431((Object)stack);
        }
        if (user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            if (stack.method_57824(DPItemDataComponents.INCUBATOR_OWNER) == null) {
                stack.method_57379(DPItemDataComponents.INCUBATOR_OWNER, (Object)new IncubatorOwner((class_1657)serverPlayer));
                user.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.daycareplus.incubator.claimed"), true);
                return class_1271.method_22427((Object)stack);
            }
            if (this.isOwnedBy(stack, serverPlayer)) {
                IncubatorType incubatorType = (IncubatorType)stack.method_57824(DPItemDataComponents.INCUBATOR_TYPE);
                if (incubatorType == null) {
                    user.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.daycareplus.incubator.typeless").method_27692(class_124.field_1061), true);
                    return class_1271.method_22431((Object)stack);
                }
                IncubatorCollection collection = IncubatorCollection.getOrCreate((class_1657)serverPlayer);
                Optional<EggStorage> currentStorage = collection.get(incubatorType.type());
                if (currentStorage.isPresent()) {
                    currentStorage.get().tryUpgradeTo(incubatorType.tier());
                } else {
                    EggStorage storage = EggStorage.fromSettings(incubatorType.tier());
                    if (storage != null) {
                        collection.put(incubatorType.type(), storage);
                    }
                }
                EggStorageGUI gui = EggStorageGUI.create(serverPlayer, incubatorType.type());
                if (gui != null) {
                    gui.open();
                }
            } else {
                user.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.daycareplus.incubator.stolen").method_27692(class_124.field_1061), true);
                return class_1271.method_22431((Object)user.method_5998(hand));
            }
        }
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    public class_1269 method_7884(class_1838 context) {
        class_2248 block = context.method_8045().method_8320(context.method_8037()).method_26204();
        if (block instanceof PastureBlock) {
            PastureBlock pastureBlock = (PastureBlock)block;
            class_1657 class_16572 = context.method_8036();
            if (class_16572 instanceof class_3222) {
                class_3222 player = (class_3222)class_16572;
                class_2338 pasturePos = pastureBlock.getBasePosition(context.method_8045().method_8320(context.method_8037()), context.method_8037());
                class_2586 class_25862 = context.method_8045().method_8321(pasturePos);
                if (class_25862 instanceof IMixinPastureBlockEntity) {
                    IMixinPastureBlockEntity daycare = (IMixinPastureBlockEntity)class_25862;
                    Optional<EggStorage> storage = this.getStorage(context.method_8041());
                    if (storage.isPresent()) {
                        int remainingSlots = storage.get().getCapacity() - storage.get().size();
                        List<class_1799> eggs = daycare.withdraw(remainingSlots);
                        eggs.forEach(storage.get()::addCopyAndEmpty);
                        this.playInsertSound(player);
                        if (eggs.size() == 1) {
                            player.method_7353((class_2561)class_2561.method_43469((String)"message.overlay.daycareplus.incubator.collection.singular", (Object[])new Object[]{eggs.size()}), true);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43469((String)"message.overlay.daycareplus.incubator.collection.plural", (Object[])new Object[]{eggs.size()}), true);
                        }
                        return class_1269.field_5812;
                    }
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.daycareplus.incubator.no_storage"), true);
                }
            }
        }
        return super.method_7884(context);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        IncubatorOwner owner = (IncubatorOwner)stack.method_57824(DPItemDataComponents.INCUBATOR_OWNER);
        if (owner != null) {
            tooltip.add((class_2561)class_2561.method_43470((String)owner.playerName()).method_27694(Styles.GRAY_NO_ITALICS));
        }
        this.getStorage(stack).ifPresent(eggStorage -> tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.daycareplus.incubator.eggs_held", (Object[])new Object[]{eggStorage.size(), eggStorage.getCapacity()}).method_27694(Styles.GRAY_NO_ITALICS)));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (player.field_6012 % 20 == 0) {
                for (int i = slot + 1; i < player.method_31548().field_7547.size(); ++i) {
                    if (!((class_1799)player.method_31548().field_7547.get(i)).method_31573(DPItemTags.INCUBATORS)) continue;
                    return;
                }
                this.tickEggs(stack, player, 20);
            }
        }
    }

    public void tickEggs(class_1799 stack, class_3222 player, int amount) {
        int abilityMultiplier = 1;
        for (Pokemon pokemon : PlayerExtensionsKt.party((class_3222)player)) {
            if (!HATCH_ABILITIES.contains(pokemon.getAbility().getName().toLowerCase(Locale.ROOT))) continue;
            abilityMultiplier = 2;
            break;
        }
        int trueAmount = amount * abilityMultiplier;
        this.getStorage(stack).ifPresent(storage -> {
            storage.tick(trueAmount, player);
            stack.method_57379(DPItemDataComponents.EGGS_HELD, (Object)storage.size());
        });
    }

    private boolean isOwnedBy(class_1799 stack, class_3222 player) {
        return ((IncubatorOwner)stack.method_57825(DPItemDataComponents.INCUBATOR_OWNER, (Object)IncubatorOwner.DEFAULT)).matches((class_1657)player);
    }

    private Optional<EggStorage> getStorage(class_1799 stack) {
        IncubatorCollection collection;
        IncubatorOwner owner = (IncubatorOwner)stack.method_57824(DPItemDataComponents.INCUBATOR_OWNER);
        IncubatorType type = (IncubatorType)stack.method_57824(DPItemDataComponents.INCUBATOR_TYPE);
        if (owner != null && type != null && (collection = IncubatorCollection.getCollection(owner.uuid())) != null) {
            return collection.get(type.type());
        }
        return Optional.empty();
    }

    @Override
    public int getPolymerCustomModelData(class_1799 stack, @Nullable class_3222 player) {
        if ((Integer)stack.method_57825(DPItemDataComponents.EGGS_HELD, (Object)0) > 0) {
            return this.hasEggData.value();
        }
        return super.getPolymerCustomModelData(stack, player);
    }

    private void playInsertSound(class_3222 player) {
        player.method_17356(class_3417.field_34376, class_3419.field_15248, 1.0f, 1.0f);
    }
}

