/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.breeding;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.CommonAbilityType;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.ShinyChanceCalculationEvent;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbilityType;
import com.provismet.cobblemon.daycareplus.api.DaycarePlusEvents;
import com.provismet.cobblemon.daycareplus.breeding.BreedingUtils;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.util.MathExtras;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kotlin.Pair;
import net.minecraft.class_1792;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class PotentialPokemonProperties {
    private final Pokemon primary;
    private final Pokemon secondary;
    private final FormData form;

    public PotentialPokemonProperties(Pokemon primary, Pokemon secondary) {
        this.primary = primary;
        this.secondary = secondary;
        this.form = BreedingUtils.getBabyForm(this.primary);
    }

    public PokemonProperties createPokemonProperties() {
        PokemonProperties properties = PokemonProperties.Companion.parse(BreedingUtils.getFormProperties(this.form), " ", "=");
        properties.setSpecies(this.form.getSpecies().showdownId());
        properties.setForm(this.form.formOnlyShowdownId());
        this.setAbility(properties);
        this.setGender(properties);
        this.setIVs(properties);
        this.setNature(properties);
        this.setEggMoves(properties);
        this.setPokeBall(properties);
        this.setShiny(properties);
        properties.setTeraType(this.form.getPrimaryType().getName());
        properties.setLevel(Integer.valueOf(1));
        properties.setFriendship(Integer.valueOf(120));
        properties.updateAspects();
        ((DaycarePlusEvents.EggPropertiesCreated)DaycarePlusEvents.EGG_PROPERTIES_CREATED.invoker()).modifyProperties(this.primary, this.secondary, properties);
        return properties;
    }

    public Pokemon getPrimary() {
        return this.primary;
    }

    public Pokemon getSecondary() {
        return this.secondary;
    }

    public Species getSpecies() {
        return this.form.getSpecies();
    }

    public FormData getForm() {
        return this.form;
    }

    public List<Nature> getPossibleNatures() {
        ArrayList<Nature> natures = new ArrayList<Nature>();
        if (this.primary.getHeldItem$common().method_31574((class_1792)CobblemonItems.EVERSTONE)) {
            natures.add(this.primary.getNature());
        }
        if (this.secondary.getHeldItem$common().method_31574((class_1792)CobblemonItems.EVERSTONE)) {
            natures.add(this.secondary.getNature());
        }
        return natures;
    }

    public List<PokeBall> getPossiblePokeBalls() {
        ArrayList<PokeBall> balls = new ArrayList<PokeBall>();
        Set<PokeBall> illegal = Set.of(PokeBalls.getMasterBall(), PokeBalls.getCherishBall());
        if (this.primary.getSpecies().getName().equalsIgnoreCase(this.secondary.getSpecies().getName())) {
            balls.add(illegal.contains(this.primary.getCaughtBall()) ? PokeBalls.getPokeBall() : this.primary.getCaughtBall());
            balls.add(illegal.contains(this.secondary.getCaughtBall()) ? PokeBalls.getPokeBall() : this.secondary.getCaughtBall());
        } else {
            balls.add(illegal.contains(this.primary.getCaughtBall()) ? PokeBalls.getPokeBall() : this.primary.getCaughtBall());
        }
        return balls;
    }

    public List<AbilityTemplate> getPossibleAbilities() {
        List abilities;
        Pair parentAbilityData;
        Ability parentAbility = this.primary.getAbility();
        if (parentAbility.getIndex() >= 0) {
            parentAbilityData = new Pair((Object)parentAbility.getPriority(), (Object)parentAbility.getIndex());
        } else {
            Optional<Map.Entry> abilities2 = this.primary.getForm().getAbilities().getMapping().entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().map(PotentialAbility::getTemplate).anyMatch(template -> template == parentAbility.getTemplate())).findFirst();
            parentAbilityData = abilities2.map(priorityListEntry -> new Pair((Object)((Priority)priorityListEntry.getKey()), (Object)((List)priorityListEntry.getValue()).stream().map(PotentialAbility::getTemplate).toList().indexOf(parentAbility.getTemplate()))).orElseGet(() -> new Pair((Object)Priority.LOWEST, (Object)0));
        }
        AbilityTemplate inheritedAbility = null;
        if (this.form.getAbilities().getMapping().containsKey(parentAbilityData.getFirst()) && !(abilities = (List)this.form.getAbilities().getMapping().get(parentAbilityData.getFirst())).isEmpty()) {
            inheritedAbility = abilities.size() > (Integer)parentAbilityData.getSecond() ? ((PotentialAbility)abilities.get((Integer)parentAbilityData.getSecond())).getTemplate() : ((PotentialAbility)abilities.getFirst()).getTemplate();
        }
        if (inheritedAbility == null) {
            abilities = (List)this.form.getAbilities().getMapping().get(Priority.LOWEST);
            inheritedAbility = abilities == null || abilities.isEmpty() ? Abilities.INSTANCE.getDUMMY() : ((PotentialAbility)abilities.getFirst()).getTemplate();
        }
        AbilityTemplate finalAbility = inheritedAbility;
        List<AbilityTemplate> otherPossibleAbilities = this.form.getAbilities().getMapping().values().stream().flatMap(Collection::stream).filter(other -> other.getType() instanceof CommonAbilityType || other.getType() instanceof HiddenAbilityType && parentAbility.getPriority() == Priority.LOW).map(PotentialAbility::getTemplate).filter(other -> other != finalAbility).toList();
        ArrayList<AbilityTemplate> potentials = new ArrayList<AbilityTemplate>();
        potentials.add(inheritedAbility);
        potentials.addAll(otherPossibleAbilities);
        return potentials;
    }

    public Map<Stat, PotentialIV> getPossibleIVs() {
        return Map.of(Stats.HP, PotentialIV.fromParents(this.primary, this.secondary, (Stat)Stats.HP), Stats.ATTACK, PotentialIV.fromParents(this.primary, this.secondary, (Stat)Stats.ATTACK), Stats.DEFENCE, PotentialIV.fromParents(this.primary, this.secondary, (Stat)Stats.DEFENCE), Stats.SPECIAL_ATTACK, PotentialIV.fromParents(this.primary, this.secondary, (Stat)Stats.SPECIAL_ATTACK), Stats.SPECIAL_DEFENCE, PotentialIV.fromParents(this.primary, this.secondary, (Stat)Stats.SPECIAL_DEFENCE), Stats.SPEED, PotentialIV.fromParents(this.primary, this.secondary, (Stat)Stats.SPEED));
    }

    public List<String> getEggMoves() {
        List validEggMoves = this.form.getMoves().getEggMoves();
        ArrayList<String> eggMoves = new ArrayList<String>();
        this.secondary.getBenchedMoves().forEach(benchedMove -> {
            if (validEggMoves.stream().anyMatch(valid -> valid.getName().equalsIgnoreCase(benchedMove.getMoveTemplate().getName()))) {
                eggMoves.add(benchedMove.getMoveTemplate().getName());
            }
        });
        this.secondary.getMoveSet().forEach(move -> {
            if (validEggMoves.stream().anyMatch(valid -> valid.getName().equalsIgnoreCase(move.getName()))) {
                eggMoves.add(move.getName());
            }
        });
        if (DaycarePlusOptions.doGen6EggMoves()) {
            this.primary.getBenchedMoves().forEach(benchedMove -> {
                if (validEggMoves.stream().anyMatch(valid -> valid.getName().equalsIgnoreCase(benchedMove.getMoveTemplate().getName()))) {
                    eggMoves.add(benchedMove.getMoveTemplate().getName());
                }
            });
            this.primary.getMoveSet().forEach(move -> {
                if (validEggMoves.stream().anyMatch(valid -> valid.getName().equalsIgnoreCase(move.getName()))) {
                    eggMoves.add(move.getName());
                }
            });
        }
        if (this.primary.getSpecies().showdownId().equals("pikachu") && this.primary.heldItem().method_31574((class_1792)CobblemonItems.LIGHT_BALL) || this.secondary.getSpecies().showdownId().equals("pikachu") && this.secondary.heldItem().method_31574((class_1792)CobblemonItems.LIGHT_BALL)) {
            eggMoves.add("volttackle");
        }
        return eggMoves;
    }

    public double getShinyRate() {
        float shinyRate;
        if (DaycarePlusOptions.shouldUseShinyChanceEvent()) {
            ShinyChanceCalculationEvent event = new ShinyChanceCalculationEvent(Cobblemon.config.getShinyRate(), this.primary);
            CobblemonEvents.SHINY_CHANCE_CALCULATION.emit((Object[])new ShinyChanceCalculationEvent[]{event});
            shinyRate = event.calculate(null);
        } else {
            shinyRate = Cobblemon.config.getShinyRate();
        }
        shinyRate /= DaycarePlusOptions.getShinyChanceMultiplier();
        if (!Objects.equals(this.primary.getOriginalTrainer(), this.secondary.getOriginalTrainer())) {
            shinyRate /= DaycarePlusOptions.getMasudaMultiplier();
        }
        if (this.primary.getShiny()) {
            shinyRate /= DaycarePlusOptions.getCrystalMultiplier();
        }
        if (this.secondary.getShiny()) {
            shinyRate /= DaycarePlusOptions.getCrystalMultiplier();
        }
        return shinyRate == 0.0f ? 1.0 : (double)(1.0f / shinyRate);
    }

    private void setPokeBall(PokemonProperties properties) {
        List<PokeBall> balls = this.getPossiblePokeBalls();
        if (Math.random() < 0.5) {
            properties.setPokeball(balls.getFirst().getName().toString());
        } else {
            properties.setPokeball(balls.getLast().getName().toString());
        }
    }

    private void setGender(PokemonProperties properties) {
        if (this.form.getMaleRatio() < 0.0f) {
            properties.setGender(Gender.GENDERLESS);
        } else if (Math.random() < (double)this.form.getMaleRatio()) {
            properties.setGender(Gender.MALE);
        } else {
            properties.setGender(Gender.FEMALE);
        }
    }

    private void setAbility(PokemonProperties properties) {
        double keepCurrentAbility;
        Pair parentAbilityData;
        Ability parentAbility = this.primary.getAbility();
        if (parentAbility.getIndex() >= 0) {
            parentAbilityData = new Pair((Object)parentAbility.getPriority(), (Object)parentAbility.getIndex());
        } else {
            Optional<Map.Entry> abilities = this.primary.getForm().getAbilities().getMapping().entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().map(PotentialAbility::getTemplate).anyMatch(template -> template == parentAbility.getTemplate())).findFirst();
            parentAbilityData = abilities.map(priorityListEntry -> new Pair((Object)((Priority)priorityListEntry.getKey()), (Object)((List)priorityListEntry.getValue()).stream().map(PotentialAbility::getTemplate).toList().indexOf(parentAbility.getTemplate()))).orElseGet(() -> new Pair((Object)Priority.LOWEST, (Object)0));
        }
        List<AbilityTemplate> potentials = this.getPossibleAbilities();
        double d = keepCurrentAbility = parentAbilityData.getFirst() == Priority.LOW ? 0.6 : 0.8;
        if (potentials.size() == 1 || Math.random() < keepCurrentAbility) {
            properties.setAbility(potentials.getFirst().getName());
        } else if (!potentials.isEmpty()) {
            potentials.removeFirst();
            int randomIndex = Math.clamp((long)((int)(Math.random() * (double)potentials.size())), 0, potentials.size() - 1);
            properties.setAbility(potentials.get(randomIndex).getName());
        }
    }

    private void setNature(PokemonProperties properties) {
        List<Nature> natures = this.getPossibleNatures();
        if (!(natures.isEmpty() || DaycarePlusOptions.doCompetitiveBreeding() && !BreedingUtils.parentsHaveFertility(this.primary, this.secondary))) {
            if (Math.random() < 0.5) {
                properties.setNature(natures.getFirst().getName().toString());
            } else {
                properties.setNature(natures.getLast().getName().toString());
            }
        } else {
            properties.setNature(((Nature)MathExtras.randomChoice(Natures.all().stream().toList())).getName().toString());
        }
    }

    private void setShiny(PokemonProperties properties) {
        properties.setShiny(Boolean.valueOf(Math.random() < this.getShinyRate()));
    }

    private void setEggMoves(PokemonProperties properties) {
        List<String> eggMoves = this.getEggMoves();
        if (properties.getMoves() != null) {
            eggMoves.addAll(properties.getMoves());
        }
        properties.setMoves(eggMoves.stream().distinct().toList());
    }

    private void setIVs(PokemonProperties properties) {
        int forcedIVs = 3;
        if (DaycarePlusOptions.doCompetitiveBreeding() && !BreedingUtils.parentsHaveFertility(this.primary, this.secondary)) {
            forcedIVs = 0;
        } else if (this.primary.heldItem().method_31574((class_1792)CobblemonItems.DESTINY_KNOT) || this.secondary.heldItem().method_31574((class_1792)CobblemonItems.DESTINY_KNOT)) {
            forcedIVs = 5;
        }
        Map<Stat, PotentialIV> potentials = this.getPossibleIVs();
        ArrayList<Stats> remaining = new ArrayList<Stats>();
        remaining.add(Stats.HP);
        remaining.add(Stats.ATTACK);
        remaining.add(Stats.DEFENCE);
        remaining.add(Stats.SPECIAL_ATTACK);
        remaining.add(Stats.SPECIAL_DEFENCE);
        remaining.add(Stats.SPEED);
        IVs iv = new IVs();
        for (Map.Entry<Stat, PotentialIV> entry : potentials.entrySet()) {
            if (!entry.getValue().isForced()) continue;
            --forcedIVs;
            iv.set(entry.getKey(), ((Integer)MathExtras.randomChoice(entry.getValue().values().stream().toList())).intValue());
            remaining.remove(entry.getKey());
        }
        for (int i = 0; i < forcedIVs && !remaining.isEmpty(); ++i) {
            Stat stat = (Stat)MathExtras.randomChoice(remaining);
            iv.set(stat, MathExtras.randomChoice(potentials.get(stat).values().stream().filter(value -> value != -1).toList()).intValue());
            remaining.remove(stat);
        }
        for (Stat stat : remaining) {
            iv.set(stat, class_3532.method_15340((int)((int)(Math.random() * 32.0)), (int)0, (int)31));
        }
        properties.setIvs(iv);
    }

    /*
     * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
     */
    public record PotentialIV(boolean isForced, Set<Integer> values) {
        public static final int WILDCARD = -1;

        /*
         * Exception decompiling
         */
        public static PotentialIV fromParents(Pokemon parent1, Pokemon parent2, Stat stat) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=1,78
             *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        @NotNull
        public String toString() {
            return String.join((CharSequence)" | ", this.values.stream().map(val -> val == -1 ? "?" : String.valueOf(val)).toList());
        }
    }
}

