/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.codec.IngredientCodecs;

public final class SizedIngredient {
    public static final SizedIngredient EMPTY = new SizedIngredient(class_1856.field_9017, 1);
    public static final Codec<SizedIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCodecs.NON_EMPTY_MAP_CODEC.forGetter(SizedIngredient::ingredient), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(SizedIngredient::count)).apply((Applicative)instance, SizedIngredient::new));
    public static final class_9139<class_9129, SizedIngredient> STREAM_CODEC = class_9139.method_56435((class_9139)class_1856.field_48355, SizedIngredient::ingredient, (class_9139)class_9135.field_48550, SizedIngredient::count, SizedIngredient::new);
    private final class_1856 ingredient;
    private final int count;
    @Nullable
    private class_1799[] cachedStacks;

    public static SizedIngredient of(class_1935 item, int count) {
        return new SizedIngredient(class_1856.method_8091((class_1935[])new class_1935[]{item}), count);
    }

    public static SizedIngredient of(class_6862<class_1792> tag, int count) {
        return new SizedIngredient(class_1856.method_8106(tag), count);
    }

    public SizedIngredient(class_1856 ingredient, int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be positive");
        this.ingredient = ingredient;
        this.count = count;
    }

    public class_1856 ingredient() {
        return this.ingredient;
    }

    public int count() {
        return this.count;
    }

    public boolean test(class_1799 stack) {
        return this.ingredient.method_8093(stack) && stack.method_7947() >= this.count;
    }

    public class_1799[] getItems() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (class_1799[])Stream.of(this.ingredient.method_8105()).map(s -> s.method_46651(this.count)).toArray(class_1799[]::new);
        }
        return this.cachedStacks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SizedIngredient)) {
            return false;
        }
        SizedIngredient other = (SizedIngredient)o;
        return this.count == other.count && this.ingredient.equals((Object)other.ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.ingredient, this.count);
    }

    public String toString() {
        return this.count + "x " + String.valueOf(this.ingredient);
    }
}

