/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.command.ClientCommandContext;
import snownee.kiwi.command.KiwiCommand;
import snownee.kiwi.config.ClothConfigIntegration;
import snownee.kiwi.config.ConfigLibAttributes;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;

public class KiwiClientCommand {
    public static <T> LiteralArgumentBuilder<T> create(ClientCommandContext<T> context) {
        LiteralArgumentBuilder<T> builder = context.literal("kiwic");
        builder.then(((LiteralArgumentBuilder)context.literal("eval").executes(ctx -> KiwiCommand.evalHelp(ctx.getSource(), context::sendFailure))).then(context.argument("expression", StringArgumentType.greedyString()).executes(ctx -> KiwiCommand.eval(StringArgumentType.getString((CommandContext)ctx, (String)"expression"), KiwiCommonConfig.evalPrintExpression, ctx.getSource(), context::sendSuccess, context::sendFailure))));
        LiteralArgumentBuilder<T> configure = context.literal("configure");
        ArrayList list = Lists.newArrayList();
        if (Platform.isModLoaded("cloth-config")) {
            list.add(ClothConfigIntegration.attributes());
        }
        if (list.isEmpty()) {
            configure.executes(ctx -> {
                context.sendSuccess(ctx.getSource(), (class_2561)class_2561.method_43471((String)"commands.kiwi.configure.install"));
                return 0;
            });
        } else {
            HashSet addedMods = Sets.newHashSet();
            for (ConfigLibAttributes attributes : list) {
                KiwiClientCommand.putMods(context, attributes, addedMods, configure);
            }
        }
        builder.then(configure);
        return builder;
    }

    private static <T> void putMods(ClientCommandContext<T> context, ConfigLibAttributes attributes, Set<String> addedMods, LiteralArgumentBuilder<T> node) {
        for (String modId : KiwiConfigManager.getModsWithScreen(attributes)) {
            if (addedMods.contains(modId)) continue;
            addedMods.add(modId);
            node.then(context.literal(modId).executes(ctx -> {
                class_437 screen = attributes.screenFactory().apply(modId);
                if (screen == null) {
                    context.sendSuccess(ctx.getSource(), (class_2561)class_2561.method_43471((String)"commands.kiwi.configure.failed"));
                    return 0;
                }
                class_310.method_1551().method_18858(() -> class_310.method_1551().method_1507(screen));
                return 1;
            }));
        }
    }
}

