/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModuleContainer;
import snownee.kiwi.ModContext;
import snownee.kiwi.loader.Platform;

public final class KiwiModules {
    private static Map<class_2960, KiwiModuleContainer> MODULES = Maps.newLinkedHashMap();
    private static final Set<class_2960> LOADED_MODULES = Sets.newHashSet();
    static final Set<class_5321<? extends class_2378<?>>> ALL_USED_REGISTRIES = Sets.newLinkedHashSet();

    private KiwiModules() {
    }

    public static void add(class_2960 resourceLocation, AbstractModule module, ModContext context) {
        Preconditions.checkArgument((!KiwiModules.isLoaded(resourceLocation) ? 1 : 0) != 0, (String)"Duplicate module: %s", (Object)resourceLocation);
        LOADED_MODULES.add(resourceLocation);
        MODULES.put(resourceLocation, new KiwiModuleContainer(resourceLocation, module, context));
    }

    public static boolean isLoaded(class_2960 module) {
        return LOADED_MODULES.contains(module);
    }

    public static Collection<KiwiModuleContainer> get() {
        return MODULES.values();
    }

    public static KiwiModuleContainer get(class_2960 moduleId) {
        return MODULES.get(moduleId);
    }

    public static void clear() {
        if (!Platform.isDataGen()) {
            MODULES = Map.of();
        }
    }

    public static void fire(Consumer<KiwiModuleContainer> consumer) {
        MODULES.values().forEach(consumer);
    }
}

