/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.util;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.pokesplash.gts.Gts;

public abstract class Utils {
    public static CompletableFuture<Boolean> writeFileAsync(String filePath, String filename, final String data) {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Path path = Paths.get(new File("").getAbsolutePath() + filePath, filename);
        final File file = path.toFile();
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            file.getParentFile().mkdirs();
        }
        try (final AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            ByteBuffer buffer = ByteBuffer.wrap(data.getBytes(StandardCharsets.UTF_8));
            fileChannel.write(buffer, 0L, buffer, new CompletionHandler<Integer, ByteBuffer>(){

                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    attachment.clear();
                    try {
                        fileChannel.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    future.complete(true);
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    future.complete(Utils.writeFileSync(file, data));
                }
            });
        }
        catch (IOException | SecurityException e) {
            Gts.LOGGER.fatal("Unable to write file asynchronously, attempting sync write.");
            future.complete(future.complete(false));
        }
        return future;
    }

    public static boolean writeFileSync(File file, String data) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(data);
            writer.close();
            return true;
        }
        catch (Exception e) {
            Gts.LOGGER.fatal("Unable to write to file for gts.\nStack Trace: ");
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteFile(String filePath, String filename) {
        try {
            Path path = Paths.get(new File("").getAbsolutePath() + filePath, filename);
            File file = path.toFile();
            if (!file.exists()) {
                return true;
            }
            file.delete();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static CompletableFuture<Boolean> readFileAsync(String filePath, String filename, Consumer<String> callback) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Path path = Paths.get(new File("").getAbsolutePath() + filePath, filename);
        File file = path.toFile();
        if (!file.exists()) {
            future.complete(false);
            executor.shutdown();
            return future;
        }
        try (AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(path, StandardOpenOption.READ);){
            ByteBuffer buffer = ByteBuffer.allocate((int)fileChannel.size());
            Future<Integer> readResult = fileChannel.read(buffer, 0L);
            readResult.get();
            buffer.flip();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            String fileContent = new String(bytes, StandardCharsets.UTF_8);
            callback.accept(fileContent);
            fileChannel.close();
            executor.shutdown();
            future.complete(true);
        }
        catch (Exception e) {
            future.complete(Utils.readFileSync(file, callback));
            executor.shutdown();
        }
        return future;
    }

    public static boolean readFileSync(File file, Consumer<String> callback) {
        try {
            Scanner reader = new Scanner(file);
            Object data = "";
            while (reader.hasNextLine()) {
                data = (String)data + reader.nextLine();
            }
            reader.close();
            callback.accept((String)data);
            return true;
        }
        catch (Exception e) {
            Gts.LOGGER.fatal("Unable to read file " + file.getName() + " for gts.\nStack Trace: ");
            e.printStackTrace();
            return false;
        }
    }

    public static File checkForDirectory(String path) {
        File dir = new File(new File("").getAbsolutePath() + path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static Gson newGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public static String formatMessage(String message, Boolean isPlayer) {
        if (isPlayer.booleanValue()) {
            return message.trim();
        }
        return message.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
    }

    public static boolean isStringInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String parseLongDate(long time) {
        long second = 1000L;
        long minute = second * 60L;
        long hour = minute * 60L;
        long day = hour * 24L;
        long timeLeft = time;
        Object output = "";
        if (timeLeft > day) {
            output = (String)output + (time - time % day) / day + "d ";
            timeLeft %= day;
        }
        if (timeLeft > hour) {
            output = (String)output + (timeLeft - timeLeft % hour) / hour + "h ";
            timeLeft %= hour;
        }
        if (timeLeft > minute) {
            output = (String)output + (timeLeft - timeLeft % minute) / minute + "m ";
            timeLeft %= minute;
        }
        if (timeLeft > second) {
            output = (String)output + (timeLeft - timeLeft % second) / second + "s ";
            timeLeft %= second;
        }
        return output;
    }

    public static String capitaliseFirst(String message) {
        if (message.trim().isEmpty()) {
            return message;
        }
        Object output = message.trim().replaceAll("\\[|\\]", "");
        String[] messages = ((String)output).split("_| ");
        if (messages.length > 1) {
            output = "";
            for (String msg : messages) {
                output = (String)output + Utils.capitaliseFirst(msg) + " ";
            }
            return output;
        }
        return ((String)output).trim().substring(0, 1).toUpperCase() + ((String)output).substring(1).toLowerCase(Locale.ROOT);
    }

    public static boolean isHA(Pokemon pokemon) {
        List abilities = (List)pokemon.getForm().getAbilities().getMapping().get(Priority.LOW);
        if (abilities == null || abilities.size() != 1) {
            return false;
        }
        String ability = ((PotentialAbility)((List)pokemon.getForm().getAbilities().getMapping().get(Priority.LOW)).get(0)).getTemplate().getName();
        return pokemon.getAbility().getName().equalsIgnoreCase(ability);
    }

    public static String formatPlaceholders(String message, double minPrice, String listing, String seller, String buyer) {
        String newMessage = message;
        if (message == null) {
            return "";
        }
        if (listing != null) {
            newMessage = newMessage.replaceAll("\\{listing\\}", listing);
        }
        if (seller != null) {
            newMessage = newMessage.replaceAll("\\{seller\\}", seller);
        }
        if (buyer != null) {
            newMessage = newMessage.replaceAll("\\{buyer\\}", buyer);
        }
        return newMessage.replaceAll("\\{min_price\\}", "" + minPrice).replaceAll("\\{max_listings\\}", "" + Gts.config.getMaxListingsPerPlayer()).replaceAll("\\{max_price\\}", "" + Gts.config.getMaximumPrice());
    }

    public static class_1799 parseItemId(String id) {
        class_2487 tag;
        try {
            tag = class_2522.method_10718((String)id);
        }
        catch (Exception e) {
            tag = new class_2487();
            tag.method_10582("id", id);
            tag.method_10569("Count", 1);
        }
        return (class_1799)class_1799.method_57360((class_7225.class_7874)class_7225.class_7874.method_46761(Stream.empty()), (class_2520)tag).get();
    }

    public static void broadcastClickable(String message, String command) {
        class_5250 component = class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, command)));
        MinecraftServer server = Gts.server;
        ArrayList players = new ArrayList(server.method_3760().method_14571());
        for (class_3222 pl : players) {
            pl.method_43496((class_2561)component);
        }
    }

    public static boolean hasSpace(class_3222 player, class_1799 stack) {
        class_2371 items = player.method_31548().field_7547;
        for (class_1799 item : items) {
            if (item.method_7960() || !class_1799.method_31577((class_1799)item, (class_1799)stack) || !item.method_7946() || item.method_7947() + stack.method_7947() > item.method_7914()) continue;
            return true;
        }
        return player.method_31548().method_7376() != -1;
    }
}

