/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.config.Config;
import org.pokesplash.gts.config.updaters.config.V2to3;
import org.pokesplash.gts.util.JsonFileUpdater;
import org.pokesplash.gts.util.Utils;

public class ConfigManager {
    private Gson gson = Utils.newGson();

    public Config loadConfig() {
        AtomicReference<Config> config = new AtomicReference<Config>(new Config());
        AtomicReference failure = new AtomicReference();
        AtomicReference<Boolean> requiresWrite = new AtomicReference<Boolean>(false);
        CompletableFuture<Boolean> read = Utils.readFileAsync("/config/gts/", "config.json", data -> {
            int version;
            JsonObject json = JsonParser.parseString((String)data).getAsJsonObject();
            try {
                version = json.get("version").getAsInt();
            }
            catch (Exception e) {
                version = 2;
                json.addProperty("version", (Number)version);
            }
            if (!json.has("version") || version < 3) {
                try {
                    json = this.updateConfig(json);
                    requiresWrite.set(true);
                }
                catch (Exception e) {
                    failure.set(e);
                }
            }
            try {
                config.set((Config)this.gson.fromJson((JsonElement)json, Config.class));
            }
            catch (Exception e) {
                failure.set(new Exception("Failed to load config"));
            }
        });
        if (!read.join().booleanValue()) {
            Gts.LOGGER.info("Could not find config for GTS. Generating a new one.");
            requiresWrite.set(true);
        } else if (failure.get() != null) {
            Gts.LOGGER.error("Could not update GTS Config: " + ((Exception)failure.get()).getMessage());
        }
        if (requiresWrite.get().booleanValue()) {
            config.get().write();
        }
        return config.get();
    }

    private JsonObject updateConfig(JsonObject json) {
        HashMap<Integer, V2to3> versions = new HashMap<Integer, V2to3>();
        versions.put(2, new V2to3());
        JsonObject out = json;
        int currentVersion = out.get("version").getAsInt();
        while (currentVersion < 3) {
            JsonFileUpdater updater = (JsonFileUpdater)versions.get(currentVersion);
            if (!updater.validate(out = updater.update(out))) {
                throw new RuntimeException("Config is invalid.");
            }
            currentVersion = out.get("version").getAsInt();
        }
        return out;
    }
}

