/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.api;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import java.util.UUID;
import net.minecraft.class_3222;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.Listing.ItemListing;
import org.pokesplash.gts.Listing.Listing;
import org.pokesplash.gts.Listing.PokemonListing;
import org.pokesplash.gts.api.economy.GtsEconomyProvider;
import org.pokesplash.gts.api.event.GtsEvents;
import org.pokesplash.gts.api.event.events.AddEvent;
import org.pokesplash.gts.api.event.events.CancelEvent;
import org.pokesplash.gts.api.event.events.PurchaseEvent;
import org.pokesplash.gts.api.event.events.ReturnEvent;
import org.pokesplash.gts.api.provider.ListingAPI;
import org.pokesplash.gts.discord.Webhook;
import org.pokesplash.gts.util.Utils;

public abstract class GtsAPI {
    public static boolean cancelListing(Listing listing) {
        boolean success;
        if (ListingAPI.getHighestPriority() != null) {
            listing.setEndTime(-20L);
            ListingAPI.getHighestPriority().update(listing);
            success = true;
        } else {
            success = Gts.listings.removeListing(listing);
            Gts.listings.addExpiredListing(listing);
        }
        GtsEvents.CANCEL.trigger(new CancelEvent(listing));
        return success;
    }

    public static boolean addListing(Listing listing, class_3222 player, Integer slot) {
        ItemListing itemListing;
        boolean removeSuccess;
        boolean success = Gts.listings.addListing(listing);
        if (listing.isPokemon()) {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            removeSuccess = party.remove((StorePosition)new PartyPosition(slot.intValue()));
        } else {
            itemListing = (ItemListing)listing;
            player.method_6047().method_7939(player.method_6047().method_7947() - itemListing.getListing().method_7947());
            removeSuccess = true;
        }
        if (!success || !removeSuccess) {
            Gts.LOGGER.error("Could not list " + listing.getListingName() + " for player: " + String.valueOf(player.method_5667()));
            if (success) {
                Gts.listings.removeListing(listing);
                listing.delete("/config/gts/listings");
            }
            if (removeSuccess) {
                if (listing.isPokemon()) {
                    PokemonListing pokemonListing = (PokemonListing)listing;
                    Cobblemon.INSTANCE.getStorage().getParty(player).add(pokemonListing.getListing());
                } else {
                    itemListing = (ItemListing)listing;
                    player.method_6047().method_7939(player.method_6047().method_7947() + itemListing.getListing().method_7947());
                }
            }
            return false;
        }
        GtsEvents.ADD.trigger(new AddEvent(listing, player));
        if (Gts.config.isBroadcastListings()) {
            Utils.broadcastClickable(Utils.formatPlaceholders(Gts.language.getNewListingBroadcast(), 0.0, listing.getListingName(), listing.getSellerName(), null), "/gts " + String.valueOf(listing.getId()));
        }
        if (Gts.config.getDiscord().isUseWebhooks()) {
            Webhook.newListing(listing);
        }
        return true;
    }

    public static boolean sale(UUID seller, class_3222 buyer, Listing listing) throws Exception {
        boolean listingsSuccess = Gts.listings.removeListing(listing);
        boolean transactionSuccess = GtsAPI.transferFunds(seller, buyer.method_5667(), listing.getPrice());
        if (!listingsSuccess) {
            Gts.listings.addListing(listing);
            if (transactionSuccess) {
                GtsAPI.revertFundTransfer(seller, buyer.method_5667(), listing.getPrice());
            }
            throw new Exception("The listing could not be removed.");
        }
        if (!transactionSuccess) {
            Gts.listings.addListing(listing);
            throw new Exception("The transaction encountered a problem.");
        }
        if (listing.isPokemon()) {
            PokemonListing pokemonListing = (PokemonListing)listing;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(buyer);
            party.add(pokemonListing.getListing());
        } else {
            ItemListing itemListing = (ItemListing)listing;
            buyer.method_31548().method_7394(itemListing.getListing());
        }
        listing.delete("/config/gts/listings");
        Gts.history.addHistoryItem(listing, buyer.method_5477().getString());
        GtsEvents.PURCHASE.trigger(new PurchaseEvent(buyer, listing));
        if (Gts.config.getDiscord().isUseWebhooks()) {
            Webhook.soldListing(listing);
        }
        return true;
    }

    private static boolean transferFunds(UUID seller, UUID buyer, double amount) {
        boolean takeSuccess = GtsEconomyProvider.getHighestEconomy().remove(buyer, amount);
        boolean giveSuccess = GtsEconomyProvider.getHighestEconomy().add(seller, (1.0 - Gts.config.getTaxRate()) * amount);
        if (!takeSuccess && giveSuccess) {
            GtsEconomyProvider.getHighestEconomy().remove(seller, (1.0 - Gts.config.getTaxRate()) * amount);
        }
        if (takeSuccess && !giveSuccess) {
            GtsEconomyProvider.getHighestEconomy().add(buyer, amount);
        }
        return takeSuccess && giveSuccess;
    }

    public static boolean hasEnoughFunds(UUID player, double amount) {
        return GtsEconomyProvider.getHighestEconomy().balance(player) >= amount;
    }

    private static void revertFundTransfer(UUID seller, UUID buyer, double amount) {
        GtsEconomyProvider.getHighestEconomy().add(buyer, amount);
        GtsEconomyProvider.getHighestEconomy().remove(seller, (1.0 - Gts.config.getTaxRate()) * amount);
    }

    public static boolean returnListing(class_3222 player, Listing listing) {
        if (listing.isPokemon()) {
            PokemonListing pokemonListing = (PokemonListing)listing;
            if (Gts.listings.removeExpiredListing(pokemonListing) && pokemonListing.delete("/config/gts/listings")) {
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                party.add(pokemonListing.getListing());
                GtsEvents.RETURN.trigger(new ReturnEvent(player, pokemonListing));
                return true;
            }
            return false;
        }
        ItemListing itemListing = (ItemListing)listing;
        if (player.method_31548().method_7376() == -1) {
            return false;
        }
        if (Gts.listings.removeExpiredListing(itemListing) && itemListing.delete("/config/gts/listings")) {
            player.method_31548().method_7394(itemListing.getListing());
            GtsEvents.RETURN.trigger(new ReturnEvent(player, itemListing));
            return true;
        }
        return false;
    }

    public static boolean cancelAndReturnListing(class_3222 player, Listing listing) {
        if (!listing.isPokemon() && player.method_31548().method_7376() == -1) {
            return false;
        }
        if (Gts.listings.removeListing(listing)) {
            listing.delete("/config/gts/listings");
            if (listing.isPokemon()) {
                PokemonListing pokemonListing = (PokemonListing)listing;
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                party.add(pokemonListing.getListing());
            } else {
                ItemListing itemListing = (ItemListing)listing;
                listing.delete("/config/gts/listings");
                player.method_31548().method_7394(itemListing.getListing());
            }
            GtsEvents.CANCEL.trigger(new CancelEvent(listing));
            GtsEvents.RETURN.trigger(new ReturnEvent(player, listing));
            return true;
        }
        return false;
    }
}

