/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.UI;

import ca.landonjw.gooeylibs2.api.UIManager;
import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import ca.landonjw.gooeylibs2.api.button.PlaceholderButton;
import ca.landonjw.gooeylibs2.api.helpers.PaginationHelper;
import ca.landonjw.gooeylibs2.api.page.LinkedPage;
import ca.landonjw.gooeylibs2.api.page.Page;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.Listing.Listing;
import org.pokesplash.gts.Listing.PokemonListing;
import org.pokesplash.gts.UI.SingleListing;
import org.pokesplash.gts.UI.button.Filler;
import org.pokesplash.gts.UI.button.ManageListings;
import org.pokesplash.gts.UI.button.NextPage;
import org.pokesplash.gts.UI.button.PreviousPage;
import org.pokesplash.gts.UI.button.RelistAll;
import org.pokesplash.gts.UI.button.SeeItemListings;
import org.pokesplash.gts.UI.module.ListingInfo;
import org.pokesplash.gts.UI.module.PokemonInfo;
import org.pokesplash.gts.enumeration.Sort;
import org.pokesplash.gts.util.ColorUtil;

public class PokemonListings {
    public Page getPage(@Nullable Sort sort) {
        List<PokemonListing> pkmListings = Gts.listings.getPokemonListings();
        if (sort.equals((Object)Sort.PRICE)) {
            pkmListings.sort(Comparator.comparingDouble(Listing::getPrice));
        } else if (sort.equals((Object)Sort.DATE)) {
            pkmListings.sort(Comparator.comparingLong(Listing::getEndTime));
        } else if (sort.equals((Object)Sort.NAME)) {
            pkmListings.sort(Comparator.comparing(PokemonListing::getListingName));
        }
        GooeyButton sortByPriceButton = GooeyButton.builder().display(Gts.language.getSortByPriceButtonItem()).with(class_9334.field_49631, (Object)ColorUtil.parse(Gts.language.getSortByPriceButtonLabel())).onClick(action -> {
            class_3222 sender = action.getPlayer();
            Page page = new PokemonListings().getPage(Sort.PRICE);
            UIManager.openUIForcefully((class_3222)sender, (Page)page);
        }).build();
        GooeyButton sortByNewestButton = GooeyButton.builder().display(Gts.language.getSortByNewestButtonItem()).with(class_9334.field_49631, (Object)ColorUtil.parse(Gts.language.getSortByNewestButtonLabel())).onClick(action -> {
            class_3222 sender = action.getPlayer();
            Page page = new PokemonListings().getPage(Sort.DATE);
            UIManager.openUIForcefully((class_3222)sender, (Page)page);
        }).build();
        GooeyButton sortByNameButton = GooeyButton.builder().display(Gts.language.getSortByNameButtonItem()).with(class_9334.field_49631, (Object)ColorUtil.parse(Gts.language.getSortByPokemonButtonLabel())).onClick(action -> {
            class_3222 sender = action.getPlayer();
            Page page = new PokemonListings().getPage(Sort.NAME);
            UIManager.openUIForcefully((class_3222)sender, (Page)page);
        }).build();
        PlaceholderButton placeholder = new PlaceholderButton();
        ArrayList<GooeyButton> pokemonButtons = new ArrayList<GooeyButton>();
        for (PokemonListing listing : pkmListings) {
            List<class_2561> lore = ListingInfo.parse(listing);
            lore.addAll(PokemonInfo.parse(listing));
            GooeyButton button = GooeyButton.builder().display(PokemonItem.from((Pokemon)listing.getListing(), (int)1)).with(class_9334.field_49631, (Object)listing.getDisplayName()).with(class_9334.field_49632, (Object)new class_9290(lore)).onClick(action -> {
                class_3222 sender = action.getPlayer();
                Page page = new SingleListing().getPage(sender, listing);
                UIManager.openUIForcefully((class_3222)sender, (Page)page);
            }).build();
            pokemonButtons.add(button);
        }
        ChestTemplate template = ChestTemplate.builder((int)6).rectangle(0, 0, 5, 9, (Button)placeholder).fill(Filler.getButton()).set(47, (Button)sortByPriceButton).set(48, (Button)sortByNewestButton).set(49, (Button)sortByNameButton).set(50, SeeItemListings.getButton()).set(51, ManageListings.getButton()).set(53, NextPage.getButton()).set(45, PreviousPage.getButton()).set(52, RelistAll.getButton()).build();
        LinkedPage page = PaginationHelper.createPagesFromPlaceholders((Template)template, pokemonButtons, null);
        page.setTitle(Gts.language.getPokemonListingsTitle());
        this.setPageTitle(page);
        return page;
    }

    private void setPageTitle(LinkedPage page) {
        LinkedPage next = page.getNext();
        if (next != null) {
            next.setTitle(Gts.language.getPokemonListingsTitle());
            this.setPageTitle(next);
        }
    }
}

