/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.Listing;

import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.Listing.Listing;

public class PokemonListing
extends Listing<Pokemon> {
    private final JsonElement pokemon;

    public PokemonListing(UUID sellerUuid, String sellerName, double price, Pokemon pokemon) {
        super(sellerUuid, sellerName, price, true);
        this.pokemon = (JsonElement)Pokemon.getCODEC().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pokemon).getOrThrow();
    }

    public PokemonListing(PokemonListing other) {
        super(UUID.fromString(other.getSellerUuid().toString()), String.copyValueOf(other.getSellerName().toCharArray()), other.getPrice(), true);
        this.pokemon = (JsonElement)Pokemon.getCODEC().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)other.getListing()).getOrThrow();
        this.id = UUID.fromString(other.getId().toString());
        this.version = String.copyValueOf(other.getVersion().toCharArray());
        super.setEndTime(other.getEndTime());
    }

    @Override
    public Pokemon getListing() {
        return (Pokemon)((Pair)Pokemon.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)this.pokemon).getOrThrow()).getFirst();
    }

    @Override
    public boolean isListingValid() {
        return this.pokemon != null && this.pokemon.isJsonObject();
    }

    public JsonElement getListingAsJsonObject() {
        return this.pokemon;
    }

    @Override
    public class_5250 getDisplayName() {
        class_2583 base = class_2583.field_24360.method_10978(Boolean.valueOf(false));
        class_2583 blue = base.method_27703((class_5251)class_5251.method_27719((String)"blue").getOrThrow());
        class_2583 dark_aqua = base.method_27703((class_5251)class_5251.method_27719((String)"dark_aqua").getOrThrow());
        class_2583 red = base.method_27703((class_5251)class_5251.method_27719((String)"red").getOrThrow());
        class_2583 yellow = base.method_27703((class_5251)class_5251.method_27719((String)"yellow").getOrThrow());
        class_2583 white = base.method_27703((class_5251)class_5251.method_27719((String)"white").getOrThrow());
        Pokemon pokemon = this.getListing();
        boolean isShiny = pokemon.getShiny();
        class_5250 displayName = pokemon.getDisplayName(Gts.showPokemonDisplayName).method_10862(isShiny ? yellow : dark_aqua);
        if (isShiny) {
            displayName.method_10852((class_2561)class_2561.method_43470((String)"\u2605").method_10862(red));
        }
        displayName.method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"cobblemon.ui.lv.number", (Object[])new Object[]{pokemon.getLevel()}).method_10862(white));
        switch (pokemon.getGender().toString()) {
            case "MALE": {
                displayName.method_10852((class_2561)class_2561.method_43470((String)" \u2642").method_10862(blue));
                break;
            }
            case "FEMALE": {
                displayName.method_10852((class_2561)class_2561.method_43470((String)" \u2640").method_10862(red));
                break;
            }
        }
        return displayName;
    }

    @Override
    public String getUiTitle() {
        return Gts.language.getPokemonTitle();
    }

    @Override
    public class_1799 getIcon() {
        return PokemonItem.from((Pokemon)this.getListing(), (int)1);
    }

    @Override
    public Listing deepClone() {
        return new PokemonListing(this);
    }

    @Override
    public String getListingName() {
        return this.getListing().getSpecies().toString();
    }
}

