/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.loading.math.MathValue;

@FunctionalInterface
public interface EasingType {
    public static final Map<String, EasingType> EASING_TYPES = new ConcurrentHashMap<String, EasingType>(64);
    public static final EasingType LINEAR = EasingType.register("linear", EasingType.register("none", value -> EasingType.easeIn(EasingType::linear)));
    public static final EasingType STEP = EasingType.register("step", value -> EasingType.easeIn(EasingType.step(value)));
    public static final EasingType EASE_IN_SINE = EasingType.register("easeinsine", value -> EasingType.easeIn(EasingType::sine));
    public static final EasingType EASE_OUT_SINE = EasingType.register("easeoutsine", value -> EasingType.easeOut(EasingType::sine));
    public static final EasingType EASE_IN_OUT_SINE = EasingType.register("easeinoutsine", value -> EasingType.easeInOut(EasingType::sine));
    public static final EasingType EASE_IN_QUAD = EasingType.register("easeinquad", value -> EasingType.easeIn(EasingType::quadratic));
    public static final EasingType EASE_OUT_QUAD = EasingType.register("easeoutquad", value -> EasingType.easeOut(EasingType::quadratic));
    public static final EasingType EASE_IN_OUT_QUAD = EasingType.register("easeinoutquad", value -> EasingType.easeInOut(EasingType::quadratic));
    public static final EasingType EASE_IN_CUBIC = EasingType.register("easeincubic", value -> EasingType.easeIn(EasingType::cubic));
    public static final EasingType EASE_OUT_CUBIC = EasingType.register("easeoutcubic", value -> EasingType.easeOut(EasingType::cubic));
    public static final EasingType EASE_IN_OUT_CUBIC = EasingType.register("easeinoutcubic", value -> EasingType.easeInOut(EasingType::cubic));
    public static final EasingType EASE_IN_QUART = EasingType.register("easeinquart", value -> EasingType.easeIn(EasingType.pow(4.0)));
    public static final EasingType EASE_OUT_QUART = EasingType.register("easeoutquart", value -> EasingType.easeOut(EasingType.pow(4.0)));
    public static final EasingType EASE_IN_OUT_QUART = EasingType.register("easeinoutquart", value -> EasingType.easeInOut(EasingType.pow(4.0)));
    public static final EasingType EASE_IN_QUINT = EasingType.register("easeinquint", value -> EasingType.easeIn(EasingType.pow(4.0)));
    public static final EasingType EASE_OUT_QUINT = EasingType.register("easeoutquint", value -> EasingType.easeOut(EasingType.pow(5.0)));
    public static final EasingType EASE_IN_OUT_QUINT = EasingType.register("easeinoutquint", value -> EasingType.easeInOut(EasingType.pow(5.0)));
    public static final EasingType EASE_IN_EXPO = EasingType.register("easeinexpo", value -> EasingType.easeIn(EasingType::exp));
    public static final EasingType EASE_OUT_EXPO = EasingType.register("easeoutexpo", value -> EasingType.easeOut(EasingType::exp));
    public static final EasingType EASE_IN_OUT_EXPO = EasingType.register("easeinoutexpo", value -> EasingType.easeInOut(EasingType::exp));
    public static final EasingType EASE_IN_CIRC = EasingType.register("easeincirc", value -> EasingType.easeIn(EasingType::circle));
    public static final EasingType EASE_OUT_CIRC = EasingType.register("easeoutcirc", value -> EasingType.easeOut(EasingType::circle));
    public static final EasingType EASE_IN_OUT_CIRC = EasingType.register("easeinoutcirc", value -> EasingType.easeInOut(EasingType::circle));
    public static final EasingType EASE_IN_BACK = EasingType.register("easeinback", value -> EasingType.easeIn(EasingType.back(value)));
    public static final EasingType EASE_OUT_BACK = EasingType.register("easeoutback", value -> EasingType.easeOut(EasingType.back(value)));
    public static final EasingType EASE_IN_OUT_BACK = EasingType.register("easeinoutback", value -> EasingType.easeInOut(EasingType.back(value)));
    public static final EasingType EASE_IN_ELASTIC = EasingType.register("easeinelastic", value -> EasingType.easeIn(EasingType.elastic(value)));
    public static final EasingType EASE_OUT_ELASTIC = EasingType.register("easeoutelastic", value -> EasingType.easeOut(EasingType.elastic(value)));
    public static final EasingType EASE_IN_OUT_ELASTIC = EasingType.register("easeinoutelastic", value -> EasingType.easeInOut(EasingType.elastic(value)));
    public static final EasingType EASE_IN_BOUNCE = EasingType.register("easeinbounce", value -> EasingType.easeIn(EasingType.bounce(value)));
    public static final EasingType EASE_OUT_BOUNCE = EasingType.register("easeoutbounce", value -> EasingType.easeOut(EasingType.bounce(value)));
    public static final EasingType EASE_IN_OUT_BOUNCE = EasingType.register("easeinoutbounce", value -> EasingType.easeInOut(EasingType.bounce(value)));
    public static final EasingType CATMULLROM = EasingType.register("catmullrom", new CatmullRomEasing());

    public Double2DoubleFunction buildTransformer(@Nullable Double var1);

    public static double lerpWithOverride(AnimationPoint animationPoint, EasingType override) {
        EasingType easingType = override;
        if (override == null) {
            easingType = animationPoint.keyFrame() == null ? LINEAR : animationPoint.keyFrame().easingType();
        }
        return easingType.apply(animationPoint);
    }

    default public double apply(AnimationPoint animationPoint) {
        Double easingVariable = null;
        if (animationPoint.keyFrame() != null && !animationPoint.keyFrame().easingArgs().isEmpty()) {
            easingVariable = ((MathValue)animationPoint.keyFrame().easingArgs().getFirst()).get();
        }
        return this.apply(animationPoint, easingVariable, animationPoint.currentTick() / animationPoint.transitionLength());
    }

    default public double apply(AnimationPoint animationPoint, @Nullable Double easingValue, double lerpValue) {
        if (animationPoint.currentTick() >= animationPoint.transitionLength()) {
            return (float)animationPoint.animationEndValue();
        }
        return class_3532.method_16436((double)((Double)this.buildTransformer(easingValue).apply((Object)lerpValue)), (double)animationPoint.animationStartValue(), (double)animationPoint.animationEndValue());
    }

    public static EasingType register(String name, EasingType easingType) {
        EASING_TYPES.putIfAbsent(name, easingType);
        return easingType;
    }

    public static EasingType fromJson(JsonElement json) {
        JsonPrimitive primitive;
        if (!(json instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)json).isString()) {
            return LINEAR;
        }
        return EasingType.fromString(primitive.getAsString().toLowerCase(Locale.ROOT));
    }

    public static EasingType fromString(String name) {
        return EASING_TYPES.getOrDefault(name, LINEAR);
    }

    public static Double2DoubleFunction linear(Double2DoubleFunction function) {
        return function;
    }

    public static double catmullRom(double n) {
        return 0.5 * (2.0 * (n + 1.0) + 2.0 + (2.0 * n - 5.0 * (n + 1.0) + 4.0 * (n + 2.0) - (n + 3.0)) + (3.0 * (n + 1.0) - n - 3.0 * (n + 2.0) + (n + 3.0)));
    }

    public static Double2DoubleFunction easeIn(Double2DoubleFunction function) {
        return function;
    }

    public static Double2DoubleFunction easeOut(Double2DoubleFunction function) {
        return time -> 1.0 - (Double)function.apply((Object)(1.0 - time));
    }

    public static Double2DoubleFunction easeInOut(Double2DoubleFunction function) {
        return time -> {
            if (time < 0.5) {
                return (Double)function.apply((Object)(time * 2.0)) / 2.0;
            }
            return 1.0 - (Double)function.apply((Object)((1.0 - time) * 2.0)) / 2.0;
        };
    }

    public static Double2DoubleFunction stepPositive(Double2DoubleFunction function) {
        return n -> n > 0.0 ? 1.0 : 0.0;
    }

    public static Double2DoubleFunction stepNonNegative(Double2DoubleFunction function) {
        return n -> n >= 0.0 ? 1.0 : 0.0;
    }

    public static double linear(double n) {
        return n;
    }

    public static double quadratic(double n) {
        return n * n;
    }

    public static double cubic(double n) {
        return n * n * n;
    }

    public static double sine(double n) {
        return 1.0 - Math.cos(n * Math.PI / 2.0);
    }

    public static double circle(double n) {
        return 1.0 - Math.sqrt(1.0 - n * n);
    }

    public static double exp(double n) {
        return Math.pow(2.0, 10.0 * (n - 1.0));
    }

    public static Double2DoubleFunction elastic(Double n) {
        double n2 = n == null ? 1.0 : n;
        return t -> 1.0 - Math.pow(Math.cos(t * Math.PI / 2.0), 3.0) * Math.cos(t * n2 * Math.PI);
    }

    public static Double2DoubleFunction bounce(Double n) {
        double n2 = n == null ? 0.5 : n;
        Double2DoubleFunction one = x -> 7.5625 * x * x;
        Double2DoubleFunction two = x -> 30.25 * n2 * Math.pow(x - 0.5454545617103577, 2.0) + 1.0 - n2;
        Double2DoubleFunction three = x -> 121.0 * n2 * n2 * Math.pow(x - 0.8181818127632141, 2.0) + 1.0 - n2 * n2;
        Double2DoubleFunction four = x -> 484.0 * n2 * n2 * n2 * Math.pow(x - 0.9545454382896423, 2.0) + 1.0 - n2 * n2 * n2;
        return t -> Math.min(Math.min((Double)one.apply((Object)t), (Double)two.apply((Object)t)), Math.min((Double)three.apply((Object)t), (Double)four.apply((Object)t)));
    }

    public static Double2DoubleFunction back(Double n) {
        double n2 = n == null ? 1.70158 : n * 1.70158;
        return t -> t * t * ((n2 + 1.0) * t - n2);
    }

    public static Double2DoubleFunction pow(double n) {
        return t -> Math.pow(t, n);
    }

    public static Double2DoubleFunction step(Double n) {
        double n2;
        double d = n2 = n == null ? 2.0 : n;
        if (n2 < 2.0) {
            throw new IllegalArgumentException("Steps must be >= 2, got: " + n2);
        }
        int steps = (int)n2;
        return t -> {
            double d;
            double result = 0.0;
            if (t < 0.0) {
                return result;
            }
            double stepLength = 1.0 / (double)steps;
            result = (double)(steps - 1) * stepLength;
            if (t > d) {
                return result;
            }
            int leftBorderIndex = 0;
            int rightBorderIndex = steps - 1;
            while (rightBorderIndex - leftBorderIndex != 1) {
                int testIndex = leftBorderIndex + (rightBorderIndex - leftBorderIndex) / 2;
                if (t >= (double)testIndex * stepLength) {
                    leftBorderIndex = testIndex;
                    continue;
                }
                rightBorderIndex = testIndex;
            }
            return (double)leftBorderIndex * stepLength;
        };
    }

    public static class CatmullRomEasing
    implements EasingType {
        public static double getPointOnSpline(double delta, double p0, double p1, double p2, double p3) {
            return 0.5 * (2.0 * p1 + (p2 - p0) * delta + (2.0 * p0 - 5.0 * p1 + 4.0 * p2 - p3) * delta * delta + (3.0 * p1 - p0 - 3.0 * p2 + p3) * delta * delta * delta);
        }

        @Override
        public Double2DoubleFunction buildTransformer(Double value) {
            return EasingType.easeInOut(EasingType::catmullRom);
        }

        @Override
        public double apply(AnimationPoint animationPoint, Double easingValue, double lerpValue) {
            if (animationPoint.currentTick() >= animationPoint.transitionLength()) {
                return animationPoint.animationEndValue();
            }
            List<?> easingArgs = animationPoint.keyFrame().easingArgs();
            if (easingArgs.size() < 2) {
                return class_3532.method_16436((double)((Double)this.buildTransformer(easingValue).apply((Object)lerpValue)), (double)animationPoint.animationStartValue(), (double)animationPoint.animationEndValue());
            }
            return CatmullRomEasing.getPointOnSpline(lerpValue, ((MathValue)easingArgs.get(0)).get(), animationPoint.animationStartValue(), animationPoint.animationEndValue(), ((MathValue)easingArgs.get(1)).get());
        }
    }
}

