/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.commands.utils;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2186;

public final class SuggestionUtils {
    public static final String BULK_ALL = "/all";
    public static final String BULK_TYPE = "/type";
    public static final String BULK_SERIES = "/series";
    private static final Map<String, Supplier<Stream<Map.Entry<String, TrainerMobData>>>> typeSuggestions = new HashMap<String, Supplier<Stream<Map.Entry<String, TrainerMobData>>>>();
    private static final Map<String, Supplier<Stream<Map.Entry<String, TrainerMobData>>>> seriesSuggestions = new HashMap<String, Supplier<Stream<Map.Entry<String, TrainerMobData>>>>();
    private static String[] GRAPH_FLAGS = new String[]{"include_defeated", "include_optionals", "include_singles"};
    public static final int GF_INCLUDE_DEFEATED = 1 << GRAPH_FLAGS.length - 1;
    public static final int GF_INCLUDE_OPTIONALS = 1 << GRAPH_FLAGS.length - 2;
    public static final int GF_INCLUDE_SINGLES = 1 << GRAPH_FLAGS.length - 3;

    public static void initSuggestions() {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        seriesSuggestions.clear();
        typeSuggestions.clear();
        sm.getSeriesIds().stream().forEach(s -> seriesSuggestions.put(String.format("%s/%s", BULK_SERIES, s), () -> tm.getAllData(new String[0]).filter(e -> ((TrainerMobData)e.getValue()).isOfSeries((String)s))));
        tm.getAllData(new String[0]).map(e -> ((TrainerMobData)e.getValue()).getType()).distinct().forEach(t -> typeSuggestions.put(String.format("%s/%s", BULK_TYPE, t.id()), () -> tm.getAllData(new String[0]).filter(e -> ((TrainerMobData)e.getValue()).getType().equals(t))));
    }

    public static boolean executeBulk(String arg, Consumer<Stream<Map.Entry<String, TrainerMobData>>> consumer) {
        if (BULK_ALL.equals(arg)) {
            consumer.accept(RCTMod.getInstance().getTrainerManager().getAllData(new String[0]));
            return true;
        }
        if (seriesSuggestions.containsKey(arg)) {
            consumer.accept(seriesSuggestions.get(arg).get());
            return true;
        }
        if (typeSuggestions.containsKey(arg)) {
            consumer.accept(typeSuggestions.get(arg).get());
            return true;
        }
        return false;
    }

    public static CompletableFuture<Suggestions> get_trainer_suggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String remaining = builder.getRemaining();
        RCTMod.getInstance().getTrainerManager().getAllData(new String[0]).map(e -> (String)e.getKey()).filter(tid -> tid.startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> get_trainer_suggestions_bulk(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String remaining = builder.getRemaining();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        if (BULK_ALL.startsWith(remaining)) {
            builder.suggest(BULK_ALL);
        }
        typeSuggestions.keySet().stream().filter(key -> key.startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        seriesSuggestions.keySet().stream().filter(key -> key.startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        tm.getAllData(new String[0]).map(e -> (String)e.getKey()).filter(tid -> tid.startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> get_series_suggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String remaining = builder.getRemainingLowerCase();
        RCTMod.getInstance().getSeriesManager().getSeriesIds().stream().filter(s -> s.startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> get_progress_trainer_suggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        Stream<Object> tidStream;
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        String remaining = builder.getRemainingLowerCase();
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 p2 = (class_1657)class_12972;
            TrainerPlayerData tpd = tm.getData(p2);
            tidStream = sm.getGraph(tpd.getCurrentSeries()).stream().filter(tn -> !tn.isAlone()).map(tn -> tn.id());
        } else {
            Stream.Builder sb = Stream.builder();
            class_2186.method_9312(context, (String)"targets").forEach(p -> {
                TrainerPlayerData tpd = tm.getData((class_1657)p);
                sm.getGraph(tpd.getCurrentSeries()).stream().filter(tn -> !tn.isAlone()).map(tn -> tn.id()).forEach(sb::accept);
            });
            tidStream = sb.build();
        }
        tidStream.distinct().filter(tid -> tid.startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> get_type_suggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String remaining = builder.getRemainingLowerCase();
        TrainerType.ids().stream().filter(id -> id.startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static int getGraphFlags(String in) throws IllegalArgumentException {
        String[] inFlags = in.toLowerCase().split(" +");
        int flags = 0;
        for (String f : inFlags) {
            boolean match = false;
            for (int i = 0; i < GRAPH_FLAGS.length; ++i) {
                if (!f.equals(GRAPH_FLAGS[i])) continue;
                flags |= 1 << GRAPH_FLAGS.length - (i + 1);
                match = true;
                break;
            }
            if (match) continue;
            throw new IllegalArgumentException(String.format("'%s' is not a valid graph flag", f));
        }
        return flags;
    }

    public static CompletableFuture<Suggestions> get_graph_flag_suggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        boolean newFlag = builder.getRemaining().endsWith(" ");
        String[] remaining = builder.getRemainingLowerCase().split(" +");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < remaining.length + (newFlag ? 0 : -1); ++i) {
            sb.append(remaining[i]).append(' ');
        }
        String pre = sb.toString();
        Stream.of(GRAPH_FLAGS).filter(flag -> Stream.of(remaining).noneMatch(f -> flag.equals(f)) && (newFlag || Stream.of(remaining).anyMatch(f -> flag.startsWith((String)f)))).forEach(f -> builder.suggest(pre + f));
        return builder.buildFuture();
    }

    private SuggestionUtils() {
    }
}

