/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.commands;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.commands.utils.SuggestionUtils;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class TrainerCommands {
    private TrainerCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rctmod").requires(css -> css.method_9259(1))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trainer").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unregister_persistent").requires(css -> css.method_9259(2))).then(class_2170.method_9244((String)"mobUUID", (ArgumentType)StringArgumentType.string()).executes(TrainerCommands::mob_unregister_persistent)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn_for").requires(css -> css.method_9259(2))).executes(TrainerCommands::mob_spawn_for)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(TrainerCommands::mob_spawn_for_target)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"summon").requires(css -> css.method_9259(2))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_summon_trainer)).then(class_2170.method_9244((String)"at", (ArgumentType)class_2262.method_9698()).executes(TrainerCommands::mob_summon_trainer_at))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"summon_persistent").requires(css -> css.method_9259(2))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_summon_persistent_trainer)).then(class_2170.method_9244((String)"at", (ArgumentType)class_2262.method_9698()).executes(TrainerCommands::mob_summon_persistent_trainer_at))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(class_2170.method_9247((String)"type").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_get_type)))).then(class_2170.method_9247((String)"max_trainer_wins").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_get_max_trainer_wins)))).then(class_2170.method_9247((String)"max_trainer_defeats").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_get_max_trainer_defeats)))).then(class_2170.method_9247((String)"reward_level_cap").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(TrainerCommands::mob_get_reward_level_cap))))).then(class_2170.method_9247((String)"required_level_cap").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(TrainerCommands::mob_get_required_level_cap))))).then(class_2170.method_9247((String)"required_defeats").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_get_required_defeats))))));
    }

    private static int mob_summon_trainer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                class_1937 level = player.method_37908();
                TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().method_5883(level);
                mob.method_33574(player.method_24515().method_10084().method_46558().method_1031(0.0, -0.5, 0.0));
                mob.setTrainerId((String)context.getArgument("trainer", String.class));
                level.method_8649((class_1297)mob);
                RCTMod.getInstance().getTrainerSpawner().register(mob);
            }
            catch (Exception e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int mob_summon_trainer_at(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().method_5883((class_1937)level);
        mob.method_33574(class_2262.method_9697(context, (String)"at").method_46558().method_1031(0.0, -0.5, 0.0));
        mob.setTrainerId((String)context.getArgument("trainer", String.class));
        level.method_8649((class_1297)mob);
        RCTMod.getInstance().getTrainerSpawner().register(mob);
        return 0;
    }

    private static int mob_summon_persistent_trainer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                class_1937 level = player.method_37908();
                TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().method_5883(level);
                mob.method_33574(player.method_24515().method_10084().method_46558().method_1031(0.0, -0.5, 0.0));
                mob.setTrainerId((String)context.getArgument("trainer", String.class));
                mob.setPersistent(true);
                level.method_8649((class_1297)mob);
                RCTMod.getInstance().getTrainerSpawner().register(mob);
            }
            catch (Exception e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int mob_summon_persistent_trainer_at(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().method_5883((class_1937)level);
        mob.method_33574(class_2262.method_9697(context, (String)"at").method_46558().method_1031(0.0, -0.5, 0.0));
        mob.setTrainerId((String)context.getArgument("trainer", String.class));
        mob.setPersistent(true);
        level.method_8649((class_1297)mob);
        RCTMod.getInstance().getTrainerSpawner().register(mob);
        return 0;
    }

    private static int mob_spawn_for(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                RCTMod.getInstance().getTrainerSpawner().attemptSpawnFor(player);
            }
            catch (Exception e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int mob_spawn_for_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = class_2186.method_9313(context, (String)"target");
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                RCTMod.getInstance().getTrainerSpawner().attemptSpawnFor(player);
            }
            catch (Exception e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.rctmod.errors.target_not_a_player"));
        return -1;
    }

    private static int mob_get_type(CommandContext<class_2168> context) throws CommandSyntaxException {
        Text type = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getType().name();
        ((class_2168)context.getSource()).method_9226(() -> type.getComponent(new Object[0]), false);
        return 0;
    }

    private static int mob_get_max_trainer_wins(CommandContext<class_2168> context) throws CommandSyntaxException {
        int max_trainer_wins = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getMaxTrainerWins();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(max_trainer_wins)), false);
        return max_trainer_wins;
    }

    private static int mob_get_max_trainer_defeats(CommandContext<class_2168> context) throws CommandSyntaxException {
        int max_trainer_defeats = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getMaxTrainerDefeats();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(max_trainer_defeats)), false);
        return max_trainer_defeats;
    }

    private static int mob_get_reward_level_cap(CommandContext<class_2168> context) throws CommandSyntaxException {
        int reward_level_cap = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getRewardLevelCap((class_1657)class_2186.method_9315(context, (String)"player"));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(reward_level_cap)), false);
        return reward_level_cap;
    }

    private static int mob_get_required_level_cap(CommandContext<class_2168> context) throws CommandSyntaxException {
        int required_level_cap = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getRequiredLevelCap((class_1657)class_2186.method_9315(context, (String)"player"));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(required_level_cap)), false);
        return required_level_cap;
    }

    private static int mob_get_required_defeats(CommandContext<class_2168> context) throws CommandSyntaxException {
        Iterator it = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getMissingRequirements(Set.of()).iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (it.hasNext()) {
            sb.append((String)it.next());
        }
        while (it.hasNext()) {
            sb.append(", ").append((String)it.next());
        }
        sb.append(']');
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(sb.toString())), false);
        return 0;
    }

    private static int mob_unregister_persistent(CommandContext<class_2168> context) throws CommandSyntaxException {
        RCTMod.getInstance().getTrainerSpawner().unregisterPersistent((String)context.getArgument("mobUUID", String.class));
        return 0;
    }
}

