/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.LevelUtils;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.Deflater;
import net.minecraft.class_1657;

public final class PlantUML {
    public static final String SERVER_URL = "https://www.plantuml.com/plantuml/svg/";
    private static final String BASE64_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_";
    private static final String SERIES_GRAPH_HEADER = "@startuml\n!theme lightgray\ntitle \"%s\"\nhide stereotypes\nhide members\nskinparam linetype ortho\nskinparam object {\narrowColor #red\narrowThickness 2\nbackgroundColor #lightblue\nbackgroundColor<<optional>> #orange\nbackgroundColor<<defeated>> #lightgray\n}\nskinparam legend {\nbackgroundColor #white\nfontColor #black\nfontSize 11\n}\nlegend top left\n<b>Legend</b>\n\n<back:lightblue> Required </back> <back:orange> Optional </back> <back:lightgray> Defeated </back>\nendlegend\n";

    public static String encode(class_1657 player, String seriesId, SeriesManager.SeriesGraph graph) {
        return PlantUML.encode(player, seriesId, graph, Set.of());
    }

    public static String encode(class_1657 player, String seriesId, SeriesManager.SeriesGraph graph, Set<String> defeats) {
        HashMap nodes = new HashMap();
        HashMap group = new HashMap();
        HashMap directed = new HashMap();
        StringBuilder sb = new StringBuilder(String.format(SERIES_GRAPH_HEADER, graph.getMetaData().title()));
        graph.stream().forEach(tn -> {
            Optional<SeriesManager.TrainerNode> sib = tn.siblings().filter(s -> nodes.containsKey(group.getOrDefault(s, s))).findFirst();
            if (sib.isPresent()) {
                NodeGroup node = (NodeGroup)nodes.get(sib.get());
                node.set.add((SeriesManager.TrainerNode)tn);
                group.put(tn, sib.get());
            } else {
                nodes.put(tn, new NodeGroup(player, (SeriesManager.TrainerNode)tn));
                group.put(tn, tn);
            }
        });
        nodes.entrySet().forEach(e -> {
            boolean[] optional_defeated = new boolean[]{((SeriesManager.TrainerNode)e.getKey()).isOptional(), ((SeriesManager.TrainerNode)e.getKey()).isDefeated(defeats)};
            StringBuilder id = new StringBuilder(String.format("<b>%d</b>\\n%s", ((NodeGroup)e.getValue()).maxRequiredLevelCap(), ((SeriesManager.TrainerNode)e.getKey()).id()));
            ((NodeGroup)e.getValue()).set.stream().sorted((a, b) -> a.id().compareTo(b.id())).forEach(tn -> {
                id.append("\\n").append(tn.id());
                optional_defeated[0] = optional_defeated[0] || tn.isOptional();
                optional_defeated[1] = optional_defeated[1] || tn.isDefeated(defeats);
            });
            sb.append(String.format("object \"%s\" as %s%s\n", id.toString(), ((SeriesManager.TrainerNode)e.getKey()).id(), optional_defeated[1] ? "<<defeated>>" : (optional_defeated[0] ? "<<optional>>" : "")));
        });
        nodes.values().forEach(ng -> {
            Set edges = directed.computeIfAbsent(ng.origin.id(), k -> new HashSet());
            String arr = ng.isOptional() ? "u" : "l";
            ng.successors().forEach(suc -> {
                SeriesManager.TrainerNode sgp = (SeriesManager.TrainerNode)group.get(suc);
                if (sgp != null && !edges.contains(sgp.id())) {
                    sb.append(String.format("%s -%s-> %s\n", ng.origin.id(), arr, sgp.id()));
                    edges.add(sgp.id());
                }
            });
        });
        sb.append("@enduml");
        return PlantUML.encode(sb.toString());
    }

    private static String encode(String input) {
        byte[] inputBytes = input.getBytes(StandardCharsets.UTF_8);
        Deflater deflater = new Deflater(1);
        deflater.setInput(inputBytes);
        deflater.finish();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            outputStream.write(buffer, 0, deflater.deflate(buffer));
        }
        deflater.end();
        return "~1" + PlantUML.base64(outputStream.toByteArray());
    }

    private static String base64(byte[] data) {
        StringBuilder encoded = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            int b0 = data[i++] & 0xFF;
            if (i == data.length) {
                encoded.append(BASE64_CHARS.charAt(b0 >> 2));
                encoded.append(BASE64_CHARS.charAt((b0 & 3) << 4));
                encoded.append("==");
                break;
            }
            int b1 = data[i++] & 0xFF;
            if (i == data.length) {
                encoded.append(BASE64_CHARS.charAt(b0 >> 2));
                encoded.append(BASE64_CHARS.charAt((b0 & 3) << 4 | b1 >> 4));
                encoded.append(BASE64_CHARS.charAt((b1 & 0xF) << 2));
                encoded.append("=");
                break;
            }
            int b2 = data[i++] & 0xFF;
            encoded.append(BASE64_CHARS.charAt(b0 >> 2));
            encoded.append(BASE64_CHARS.charAt((b0 & 3) << 4 | b1 >> 4));
            encoded.append(BASE64_CHARS.charAt((b1 & 0xF) << 2 | b2 >> 6));
            encoded.append(BASE64_CHARS.charAt(b2 & 0x3F));
        }
        return encoded.toString();
    }

    private PlantUML() {
    }

    private static class NodeGroup {
        public final Set<SeriesManager.TrainerNode> set = new HashSet<SeriesManager.TrainerNode>();
        public final SeriesManager.TrainerNode origin;
        public final class_1657 player;

        public NodeGroup(class_1657 player, SeriesManager.TrainerNode origin) {
            this.origin = origin;
            this.player = player;
        }

        public int maxRequiredLevelCap() {
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            return Stream.concat(Stream.of(this.origin), this.set.stream()).map(tn -> tm.getData(tn.id()).getRequiredLevelCap(this.player)).max(Integer::compare).orElse(LevelUtils.maxLevel());
        }

        public boolean isOptional() {
            return this.origin.isOptional() && this.set.stream().allMatch(nd -> nd.isOptional());
        }

        public Stream<SeriesManager.TrainerNode> successors() {
            Stream<SeriesManager.TrainerNode> s = this.origin.successors();
            for (SeriesManager.TrainerNode tn : this.set) {
                s = Stream.concat(s, tn.successors());
            }
            return s.distinct();
        }
    }
}

