/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.advancements.criteria;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemory;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public record DefeatCountTriggerInstance(List<String> trainerIds, String trainerType, int count) implements class_4558.class_8788
{
    public static final Codec<DefeatCountTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).optionalFieldOf("trainer_ids", List.of()).forGetter(DefeatCountTriggerInstance::trainerIds), (App)Codec.STRING.optionalFieldOf("trainer_type", (Object)"").forGetter(DefeatCountTriggerInstance::trainerType), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(DefeatCountTriggerInstance::count)).apply((Applicative)instance, DefeatCountTriggerInstance::new));

    public boolean matches(class_3222 player, TrainerMob mob) {
        TrainerBattleMemory battleMem = RCTMod.getInstance().getTrainerManager().getBattleMemory(mob);
        TrainerMobData mobTr = RCTMod.getInstance().getTrainerManager().getData(mob);
        PlayerState playerState = PlayerState.get((class_1657)player);
        if (!this.trainerIds.isEmpty() && this.trainerIds.contains(mob.getTrainerId())) {
            return battleMem.getDefeatByCount(mob.getTrainerId(), (class_1657)player) >= this.count;
        }
        if (!this.trainerType.isEmpty() && this.trainerType.equals(mobTr.getType().name())) {
            return this.count >= 0 ? playerState.getTypeDefeatCount(mobTr.getType(), true) >= (long)this.count : playerState.getTypeDefeatCount(mobTr.getType(), true) >= RCTMod.getInstance().getTrainerManager().getAllData(new String[0]).map(entry -> (TrainerMobData)entry.getValue()).filter(tmd -> tmd.getType().equals(mobTr.getType())).count();
        }
        return this.trainerIds.isEmpty() && this.trainerType.isEmpty() && battleMem.getDefeatByCount(mob.getTrainerId(), (class_1657)player) >= this.count;
    }

    public Optional<class_5258> comp_2029() {
        return Optional.empty();
    }
}

